unit fHistErrcode;

{$mode objfpc}{$H+}

interface

uses
  Forms, ExtCtrls, StdCtrls, (*ZConnection,*) Classes, SysUtils;

type

  { TfrmErrCode }

  TfrmErrCode = class(TForm)
    btnCancel: TButton;
    btnOK: TButton;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    procedure btnOKClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    DB: THandle; // TZConnection;
    sValue: String;
  end;

var
  frmErrCode: TfrmErrCode;

implementation

{$R *.lfm}

{ TfrmErrCode }

procedure TfrmErrCode.btnOKClick(Sender: TObject);
begin
  sValue := IntToStr(RadioGroup1.ItemIndex) + IntToStr(RadioGroup2.ItemIndex) + IntToStr(RadioGroup3.ItemIndex);
end;

procedure TfrmErrCode.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;

procedure TfrmErrCode.FormShow(Sender: TObject);
begin
  RadioGroup1.ItemIndex := StrToIntDef(Copy(sValue, 1, 1), -1);
  RadioGroup2.ItemIndex := StrToIntDef(Copy(sValue, 2, 1), -1);
  RadioGroup3.ItemIndex := StrToIntDef(Copy(sValue, 3, 1), -1);
end;

procedure TfrmErrCode.RadioGroup1Click(Sender: TObject);
begin
  btnOK.Enabled := (RadioGroup1.ItemIndex >= 0) And
    (RadioGroup2.ItemIndex >= 0) And
    (RadioGroup3.ItemIndex >= 0);
end;

end.

