#!/bin/bash

### EleLa - Elektronik Lagerverwaltung V3.1
### http://www.mmvisual.de/
### (c) by MmVisual, Markus Müller
###
### Script fuer die interaktive Installation, Konfiguration*, Sicherung*, Wiederherstellung, Verteilung* von EleLa.

### Lauffaehig unter Raspberry Pi ARM, Linux 32-bit, 64-bit
### by Mr.AtiX, 200510, v0.33


# Heartbeat, simple step responder and log
[ ! -f "/tmp/elela" ] && touch /tmp/elela || echo "0 init" > /tmp/elela
# todo: heartbeat auf Abbruch und Neustart pruefen = Wiederaufnahme zur Rekonfiguration 


# Kernel und Architektur feststellen
echo "10 start" >> /tmp/elela
archbit=""
case $(uname -m) in
  amd64|x86_64) export archbit="64" ;;
  i?86|x86)     export archbit="32" ;;
  arm|armhf)    dpkg --print-architecture | grep -q "arm64" && archbit="rpi64" || archbit="rpi32" ;;
  *)            echo -n "[i] Diese Hardware Architektur wurde noch nicht getestet. Es scheint ein ${getconf LONG_BIT}-bit System zu sein."
                echo "Installation ohne Gewaehr."
                echo "10f: ${getconf LONG_BIT}" >> /tmp/elela
                echo "10f: ${uname -a}" >> /tmp/elela
                echo "10f: ${lscpu}" >> /tmp/elela ;;
esac
echo "10abc: $archbit" >> /tmp/elela

kernel=""
case $(uname -s) in
  Linux)   kernel="Linux" ;;
  Darwin)  kernel="mac" ;;
  FreeBSD) kernel="freebsd" ;;
  *)       echo -n "[ ! ] Unbekannter OS Kernel: '$kernel'."
           echo -n "Installation wird nicht unterstuetzt. Abbruch."
           echo "11f: $kernel" >> /tmp/elela
           exit 127 ;;
esac
echo "11a: $kernel" >> /tmp/elela


# Variablen
export ELELADIR="$HOME/EleLa" # Installationsverzeichnis
export USERDESK=`xdg-user-dir DESKTOP`
export srcfile="EleLa_V3" # Namenskonvention Release
export version=`cat $ELELADIR/EleLa.ini | grep "Version=" | cut -d = -f 2`
export build=$(echo $version | cut -d . -f 3)
echo "12: $ELELADIR" >> /tmp/elela
echo "12: $version" >> /tmp/elela


# Downloadverzeichnis ermitteln
if [ -d $ELELADIR/Temp ]; then
  # update mode candidate
  test "$(ls -A $ELELADIR/Temp/)" && echo "[i] Eine bestehende EleLa-Installation wurde entdeckt." && echo "13d: $ELELADIR/Temp found, not empty" >> /tmp/elela
  test "$(ls -l $ELELADIR/Temp/${srcfile}*.zip)" && echo "13e: $ELELADIR/Temp found, zips present" >> /tmp/elela
  export DLSRCDIR=${ELELADIR}/Temp
  echo "13f: ${DLSRCDIR}" >> /tmp/elela
else
  export DLSRCDIR=`xdg-user-dir DOWNLOAD`
  echo "13g: ${DLSRCDIR}" >> /tmp/elela
fi


# Pakete installieren
echo 15 >> /tmp/elela
echo "Systempakete und Abhaengigkeiten werden installiert..."
sudo apt-get update -qq && sudo apt-get install -qq -o=Dpkg::Use-Pty=0 curl dialog wget unzip tzdata
echo 15a >> /tmp/elela

# CHM-Viewer installieren
if [ "`echo $XDG_DATA_DIRS | grep -Eo 'xfce|kde|gnome|mate'`" = "kde" ]; then
  sudo apt-get install -qq -o=Dpkg::Use-Pty=0 kchmviewer okular # kde
  echo 15b >> /tmp/elela
else
  echo $DESKTOP_SESSION
  sudo apt-get install -qq -o=Dpkg::Use-Pty=0 xchm # gnome,xfce,mate
  echo 15c >> /tmp/elela
fi

# fuer Datenspeicher im Netzwerk (optional)
sudo apt-get install smbclient nfs-common
echo 16a >> /tmp/elela

# fuer Datenbank (optional)
#todo: check using mysql or mariadb
#sudo apt-get install mysql-client
sudo apt-get install mariadb-client
echo 16b >> /tmp/elela


# Zeitzone setzen und aktivieren
echo 17 >> /tmp/elela
echo "Zeitzone DE wird gesetzt..."
sudo timedatectl set-timezone Europe/Berlin
sudo ln -fs /usr/share/zoneinfo/Europe/Berlin /etc/localtime
sudo sh -c 'echo "Europe/Berlin" > /etc/timezone && dpkg-reconfigure -f noninteractive tzdata'


# Auf bestehende Installation prüfen
echo 18 >> /tmp/elela
[ -d "$ELELADIR" ] && echo "[i] Das Installationsverzeichnis ist bereits vorhanden." || mkdir -p $ELELADIR
echo 18a >> /tmp/elela


# Laufende Instanz
# todo: laufende instanz beenden
# todo: haengende instanz abschiessen


# Pre Installer, Versionscheck
srcfile="EleLa_V3.1"
export dlsrcfile=""
export dlversion=""
export dlbuild=""
echo "Derzeit installierte Version ist: ${version}"
echo "21: ${version}" >> /tmp/elela

if [ -f "${DLSRCDIR}/${srcfile}*_Linux${archbit}.zip" ]; then
  echo 21a >> /tmp/elela
  echo "Im Zwischenspeicher wurden folgende Pakete gefunden:"
  ls -h ${DLSRCDIR}/${srcfile}*_Linux${archbit}.zip
  # Dateinamen zerlegen "EleLa_V3.1.20506_Linux64.zip"
  dlsrcfile=`ls -c ${DLSRCDIR}/${srcfile}*_Linux${archbit}.zip | head -n1`
  dlversion=$(echo $dlsrcfile | cut -d _ -f 2 | cut -b 2-10)
  dlbuild=$(echo $dlsrcfile | cut -d . -f 3 | cut -b 1-5)
  echo 21b >> /tmp/elela

  # Versionsvergleich, downgrade protection
  if [ "$dlbuild" -gt "$build" ]; then
    echo "[i] Eine neue Programmversion ist verfuegbar."
    echo "21c: ${build} " >> /tmp/elela
    echo "21d: ${dlbuild} " >> /tmp/elela
  
    # Update, Archiv entpacken
    echo "[ ? ] Soll ${srcfile} von ${build} auf ${dlbuild} aktualisiert werden? [J/n]: "
    read input
    echo 22 >> /tmp/elela
    case $input in
      j*|J*|y*|Y*) echo "Aktualisierung beginnt..."
        echo 22a >> /tmp/elela
        cp -i $ELELADIR/EleLa.${archbit} $ELELADIR/Backup/EleLa_${build}.${archbit} # backup old
        echo "Archiv wird entpackt..."
        unzip -o $dlsrcfile -d $ELELADIR/
        echo "Aktualisierung abgeschlossen."
        chmod +x $ELELADIR/EleLa.$archbit
        # rm i $dlsrcfile
        #exit 0 # deaktiviert, post install soll noch durchlaufen
        ;;
      n*|N*) echo "Ueberspringe Aktualisierung."
        echo 22x >> /tmp/elela
        ;;
      c*|x*|q*) echo "Programmabbruch. Ende."
        echo 22q >> /tmp/elela
        exit 127
        ;;
    esac
  fi


# Restore
elif [[ -f "${ELELADIR}/Backup/*.bz2}" ] -o [ -f "${HOME}/backup/${HOSTNAME}/elela/*.bz2" ]]; then
  echo 23 >> /tmp/elela
  echo "[ ? ] Sicherung gefunden. Wiederherstellung starten? [j/N]: "
  read input
  echo "23a: ${input}" >> /tmp/elela
  case $input in
    j*|J*|y*|Y*) echo "Wiederherstellung beginnt..."
      echo 23b >> /tmp/elela
      tar -xjvf ${ELELADIR}/${srcfile*.bz2} -C $HOME # extract full path
      # Errorlevel von tar abfangen
      if [ $? -eq 0 ] ; then
        echo "[OK] Wiederherstellung erfolgreich."
        echo 23c >> /tmp/elela
      else
        echo "[Err] Wiederherstellung fehlgeschlagen."
        echo 23f >> /tmp/elela
        exit 1
      fi
      echo "Wiederherstellung abgeschlossen."
      exit 0
      ;;
    c*|x*|q*) echo "Programmabbruch. Ende."
      echo 23q >> /tmp/elela
      exit 127
      ;;
    *) echo "Ueberspringe Wiederherstellung."
      echo 23x >> /tmp/elela
      ;;
  esac


# Deployment
elif [ -f "${DLSRCDIR}/*.tgz}" ]; then
  echo 25 >> /tmp/elela
  echo "[i] Depolyment: Ein angepasstes Paket wurde gefunden und wird angewendet."
  tar -xzvf ${DLSRCDIR}/${srcfile*.tgz} -C $ELELADIR
  # Errorlevel von tar abfangen
  if [ $? -eq 0 ] ; then
    echo "[OK] Aktualisierung erfolgreich."
    echo 25c >> /tmp/elela
  else
    echo "[Err] Aktualisierung fehlgeschlagen."
    echo 25f >> /tmp/elela
    exit 1
  fi
  echo "Rekonfiguration abgeschlossen. Ende."
  exit 0


# no install packages
elif [[ ! -f "${DLSRCDIR}/${srcfile*}" ]] -a [[ ! -f "${ELELADIR}/Temp/${srcfile*}" ]]; then
  echo "[ ! ] Es konnte keine Installation oder Aktualisierung vorgenommen werden."
  echo "In den Verzeichnissen $DLSRCDIR oder $ELELADIR/Temp"
  echo "befindet sich kein gueltiges zip-Archiv fuer eine Installation."
  echo "Bitte die gewuenschte $srcfile* Version von"
  echo "http://www.mmvisual.de/elela herunterladen und waehrend der Installation vorhalten. Ende."
  echo 29a >> /tmp/elela && exit 127

  # Downloader
  echo 30 >> /tmp/elela
  cd $DLSRCDIR
  srcfile="EleLa_V3"
  #wget -qc "$url" -O "${DLSRCDIR}/${srcfile}"
  #wget -t1 -nd -cNS... ${DLSRCDIR} # url-Liste der Downloads


else
  # Installation der v3.1 Stable, durch zusammenstellen und entpacken
  echo 34 >> /tmp/elela
  echo "[ ? ] Soll eine NEUinstallation durchgefuehrt werden? [j/N]: "
  read input
  echo 34a >> /tmp/elela
  case $input in
    j*|J*|y*|Y*) echo "Installation beginnt..."
      echo 35a >> /tmp/elela
      echo "Archive werden entpackt..."
      [ -f $DLSRCDIR/EleLa_V3.0.18B15_RaspberryPi_Install.zip ] && unzip -o EleLa_V3.0.18B15_RaspberryPi_Install.zip -d $HOME/
      echo 35c >> /tmp/elela
      [ -f $DLSRCDIR/EleLa_V3.0.18B15_Linux32.zip ] && unzip -o EleLa_V3.0.18B15_Linux32.zip -d $ELELADIR/
      echo 35d >> /tmp/elela
      [ -f $DLSRCDIR/EleLa_V3.0.18B15_Linux64.zip ] && unzip -o EleLa_V3.0.18B15_Linux64.zip -d $ELELADIR/
      echo 35e >> /tmp/elela
      [ -f $DLSRCDIR/EleLa_V3.1.20309_RaspberryPi.zip ] && unzip -o EleLa_V3.1.20309_RaspberryPi.zip -d $ELELADIR/
      echo 35f >> /tmp/elela
      [ -f $DLSRCDIR/EleLa_V3.1.20309_Linux32.zip ] && unzip -o EleLa_V3.1.20309_Linux32.zip -d $ELELADIR/
      echo 35g >> /tmp/elela
      [ -f $DLSRCDIR/EleLa_V3.1.20309_Linux64.zip ] && unzip -o EleLa_V3.1.20309_Linux64.zip -d $ELELADIR/
      echo 35h >> /tmp/elela
      [ -f $DLSRCDIR/Murata_V3.1.zip ] && unzip -o Murata_V3.1.zip -d $ELELADIR/
      echo 35i >> /tmp/elela
      [ -f $DLSRCDIR/NXP_CaseAll_V3.1.zip ] && unzip -o NXP_CaseAll_V3.1.zip -d $ELELADIR/
      echo 35j >> /tmp/elela
      chmod +x $ELELADIR/EleLa.$archbit
      [ -f $ELELADIR/EleLa.rpi ] && chmod +x $ELELADIR/EleLa.rpi
      echo "[OK] Entpacken abgeschlossen."
      echo 35k >> /tmp/elela
      cp -u EleLa.chm $ELELADIR/
      echo 35l >> /tmp/elela
      ;;
    c*|x*|q*) echo "Programmabbruch. Ende."
      echo 35q >> /tmp/elela
      exit 127
      ;;
    *) echo "Manuelle Installation uebersprungen."
      echo 35n >> /tmp/elela
      #break
      ;;
  esac
fi


# Post-Installer
# Musterdaten
cp -u $ELELADIR/EleLa.sq3 $ELELADIR/EleLa.sq3.bak # backup
echo 55 >> /tmp/elela
echo "Vorlagen/Musterdaten einfuegen fuer:"
echo " (E)lektronik-Datenbank"
echo " (W)aren-Datenbank"
echo " (N)ein, leere Datenbank."
echo "[ ? ] EleLa soll genutzt werden als [e/w/N]: "
  read input
  echo "55a: ${input}" >> /tmp/elela
  case $input in
    e*|E*) echo "Musterdaten fuer Elektronik-Datenbank werden eingefuegt..."
      cp -u $ELELADIR/EleLa_Elektronik.sq3 $ELELADIR/EleLa.sq3
      echo 55b >> /tmp/elela
      ;;
    w*|W*) echo "Musterdaten fuer Waren-Datenbank werden eingefuegt..."
      cp -u $ELELADIR/EleLa_Waren.sq3 $ELELADIR/EleLa.sq3
      echo 55c >> /tmp/elela
      ;;
    c*|x*|q*) echo "Programmabbruch. Ende."
      echo 55q >> /tmp/elela
      exit 127
      ;;
    *) echo "Leere Datenbank wird beibehalten."
      echo 5d >> /tmp/elela
      ;;
  esac


# Starter fuer Desktop/Arbeitsflaeche/Schreibtisch/Menue
echo 57 >> /tmp/elela
if [ ! -f "$USERDESK/EleLa.desktop" ]; then
  echo 57a >> /tmp/elela
  echo "Programmverknuepfung wird angelegt..."
  # auf den richtigen desktop setzen
  mv -n $HOME/Desktop/EleLa.desktop $USERDESK/
  [ ! -w $USERDESK/EleLa.desktop ] && chmod u+rw $USERDESK/EleLa.desktop
  [ ! -x $USERDESK/EleLa.desktop ] && chmod ug+rx $USERDESK/EleLa.desktop
  chmod o- $USERDESK/EleLa.desktop
  # inhalt vervollstaendigen
  echo "GenericName[de]=Lagerverwaltung" | tee -a $USERDESK/EleLa.desktop
  echo "Comment[de]=Elektronik Lagerverwaltung" | tee -a $USERDESK/EleLa.desktop
  echo "Comment[pl]=" | tee -a $USERDESK/EleLa.desktop
  echo "Categories=Office;Electronics;" | tee -a $USERDESK/EleLa.desktop
  echo 57b >> /tmp/elela
fi

# Starter fuer raspi
if [[ archbit="rpi32" ] -o [ archbit="rpi64" ]]; then
  echo 27c >> /tmp/elela
  cp -u $USERDESK/EleLa.desktop $ELELADIR/EleLa-rpi.desktop
  sudo cp -u $USERDESK/EleLa.desktop /usr/share/raspi-ui-overrides/applications/

# Starter umschreiben fuer x86/x64
elif [[ archbit="32" ] -o [ archbit="64" ]]; then
  echo 27d >> /tmp/elela
  sed -i 's/\/home\/pi\/EleLa/${ELELADIR}/g' $USERDESK/EleLa.desktop
  sed -i 's/.rpi/.${archbit}/' $USERDESK/EleLa.desktop
  cp -u $USERDESK/EleLa.desktop $ELELADIR/EleLa-x${archbit}.desktop
  sudo cp -u $USERDESK/EleLa.desktop /usr/share/applications/

else
    echo "[Err] Undefinierter Zustand. Ende."
    echo 25f >> /tmp/elela
    exit 127
fi


# Mountpoints eintragen
echo 60 >> /tmp/elela
echo "#//SERVER/SHARE  ${ELELADIR}/Handbuch  cifs  user=$USER,password=$PASS,vers=1.0,iocharset=utf8,rw,file_mode=0777,dir_mode=0777,nounix,x-systemd.requires=network-online.target  0 0" | sudo tee -a /etc/fstab
echo "#//cronas/data  /mnt/cronas/data  cifs  rw,user,credentials=${HOME}/.smb,vers=3.0  0 0" | sudo tee -a /etc/fstab
echo "#cronas:/export/data  /mnt/cronas/data  nfs rw  0 0" | sudo tee -a /etc/fstab
echo "#/mnt/cronas/data/elela  ${ELELADIR}  none bind,rw  0 0" | sudo tee -a /etc/fstab
echo 60a >> /tmp/elela

echo "[i] Mountpoint-Beispiele wurden eingetragen. Bitte anpassen und aktivieren..."
sudo nano +99 -Bw /etc/fstab
echo 61 >> /tmp/elela

[ -d "/mnt/cronas" ] && {sudo mkdir -p /mnt/cronas/data/elela; echo 62a >> /tmp/elela; }
echo 62b >> /tmp/elela


# Customizing $ELELADIR/EleLa.ini
# $http_proxy pruefen, uebergeben, eintragen


# Kofigurationscheck
# Verzeichnisse abs/rel aus ini auslesen, anlegen
# EleLa.ini ...Dir=
[ ! -d "$ELELADIR/Backup" ] && mkdir -p $ELELADIR/Backup # lokaler/eingehaengter Sicherungspeicher
[ ! -d "$ELELADIR/Handbuch" ] && mkdir -p $ELELADIR/Handbuch # lokaler/eingehaengter Datenspeicher
[ ! -d "$ELELADIR/Projekt" ] && mkdir -p $ELELADIR/Projekt # lokaler/eingehaengter Projektspeicher
echo 75a >> /tmp/elela

# Rechte durchziehen
sudo chown -R $USER:$USER $ELELADIR
[ -d "/mnt/cronas/data/elela" ] && {sudo chown -R $USER:$USER /mnt/cronas/data/elela; echo 80b >> /tmp/elela; }
echo 80f >> /tmp/elela


# ENDE
echo "[i] Done, letzter Schritt: `tail -n 1 /tmp/elela`" && echo "Ende." 
# env -u && rm /tmp/elela
exit 0

